CREATE OR REPLACE FUNCTION add_column_secret_key_to_glb_usu()
RETURNS VOID AS
$BODY$
BEGIN
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS
                   WHERE TABLE_NAME ILIKE 'glb_usu'
                   AND COLUMN_NAME ILIKE 'secret_key') THEN
        ALTER TABLE glb_usu
        ADD secret_key VARCHAR(255); -- Ajuste o tamanho do campo conforme necessário
        RAISE NOTICE 'Coluna secret_key adicionada à tabela glb_usu!';
    END IF;
END;
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION add_column_secret_key_to_glb_usu() OWNER TO postgres;
SELECT add_column_secret_key_to_glb_usu();
DROP FUNCTION add_column_secret_key_to_glb_usu();